<?php

declare(strict_types=1);

/**
 * vim:set softtabstop=4 shiftwidth=4 expandtab:
 *
 * LICENSE: GNU Affero General Public License, version 3 (AGPL-3.0-or-later)
 * Copyright Ampache.org, 2001-2024
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Ampache\Module\Application;

use function DI\autowire;

return [
    ApplicationRunner::class => autowire(ApplicationRunner::class),
    Song\DeleteAction::class => autowire(Song\DeleteAction::class),
    Song\ConfirmDeleteAction::class => autowire(Song\ConfirmDeleteAction::class),
    Song\ShowLyricsAction::class => autowire(Song\ShowLyricsAction::class),
    Song\ShowSongAction::class => autowire(Song\ShowSongAction::class),
    Album\DeleteAction::class => autowire(Album\DeleteAction::class),
    Album\ConfirmDeleteAction::class => autowire(Album\ConfirmDeleteAction::class),
    Album\UpdateFromTagsAction::class => autowire(Album\UpdateFromTagsAction::class),
    Album\SetTrackNumbersAction::class => autowire(Album\SetTrackNumbersAction::class),
    Album\ShowMissingAction::class => autowire(Album\ShowMissingAction::class),
    Album\ShowAction::class => autowire(Album\ShowAction::class),
    Artist\DeleteAction::class => autowire(Artist\DeleteAction::class),
    Artist\ConfirmDeleteAction::class => autowire(Artist\ConfirmDeleteAction::class),
    Artist\ShowAction::class => autowire(Artist\ShowAction::class),
    Artist\ShowAllSongsAction::class => autowire(Artist\ShowAllSongsAction::class),
    Artist\ShowSongsAction::class => autowire(Artist\ShowSongsAction::class),
    Artist\UpdateFromMusicBrainzAction::class => autowire(Artist\UpdateFromMusicBrainzAction::class),
    Artist\UpdateFromTagsAction::class => autowire(Artist\UpdateFromTagsAction::class),
    Artist\ShowMissingAction::class => autowire(Artist\ShowMissingAction::class),
    Stats\ShowUserAction::class => autowire(Stats\ShowUserAction::class),
    Stats\NewestAlbumAction::class => autowire(Stats\NewestAlbumAction::class),
    Stats\NewestAlbumDiskAction::class => autowire(Stats\NewestAlbumDiskAction::class),
    Stats\NewestAlbumArtistAction::class => autowire(Stats\NewestAlbumArtistAction::class),
    Stats\NewestArtistAction::class => autowire(Stats\NewestArtistAction::class),
    Stats\NewestPlaylistAction::class => autowire(Stats\NewestPlaylistAction::class),
    Stats\NewestPodcastEpisodeAction::class => autowire(Stats\NewestPodcastEpisodeAction::class),
    Stats\NewestSongAction::class => autowire(Stats\NewestSongAction::class),
    Stats\NewestVideoAction::class => autowire(Stats\NewestVideoAction::class),
    Stats\PopularAlbumAction::class => autowire(Stats\PopularAlbumAction::class),
    Stats\PopularAlbumArtistAction::class => autowire(Stats\PopularAlbumArtistAction::class),
    Stats\PopularAlbumDiskAction::class => autowire(Stats\PopularAlbumDiskAction::class),
    Stats\PopularArtistAction::class => autowire(Stats\PopularArtistAction::class),
    Stats\PopularPlaylistAction::class => autowire(Stats\PopularPlaylistAction::class),
    Stats\PopularPodcastEpisodeAction::class => autowire(Stats\PopularPodcastEpisodeAction::class),
    Stats\PopularSongAction::class => autowire(Stats\PopularSongAction::class),
    Stats\PopularVideoAction::class => autowire(Stats\PopularVideoAction::class),
    Stats\HighestAlbumAction::class => autowire(Stats\HighestAlbumAction::class),
    Stats\HighestAlbumArtistAction::class => autowire(Stats\HighestAlbumArtistAction::class),
    Stats\HighestAlbumDiskAction::class => autowire(Stats\HighestAlbumDiskAction::class),
    Stats\HighestArtistAction::class => autowire(Stats\HighestArtistAction::class),
    Stats\HighestPlaylistAction::class => autowire(Stats\HighestPlaylistAction::class),
    Stats\HighestPodcastEpisodeAction::class => autowire(Stats\HighestPodcastEpisodeAction::class),
    Stats\HighestSongAction::class => autowire(Stats\HighestSongAction::class),
    Stats\HighestVideoAction::class => autowire(Stats\HighestVideoAction::class),
    Stats\UserflagAlbumAction::class => autowire(Stats\UserflagAlbumAction::class),
    Stats\UserflagAlbumArtistAction::class => autowire(Stats\UserflagAlbumArtistAction::class),
    Stats\UserflagAlbumDiskAction::class => autowire(Stats\UserflagAlbumDiskAction::class),
    Stats\UserflagArtistAction::class => autowire(Stats\UserflagArtistAction::class),
    Stats\UserflagPlaylistAction::class => autowire(Stats\UserflagPlaylistAction::class),
    Stats\UserflagPodcastEpisodeAction::class => autowire(Stats\UserflagPodcastEpisodeAction::class),
    Stats\UserflagSongAction::class => autowire(Stats\UserflagSongAction::class),
    Stats\UserflagVideoAction::class => autowire(Stats\UserflagVideoAction::class),
    Stats\RecentAlbumArtistAction::class => autowire(Stats\RecentAlbumArtistAction::class),
    Stats\RecentAlbumDiskAction::class => autowire(Stats\RecentAlbumDiskAction::class),
    Stats\RecentArtistAction::class => autowire(Stats\RecentArtistAction::class),
    Stats\RecentPlaylistAction::class => autowire(Stats\RecentPlaylistAction::class),
    Stats\RecentPodcastEpisodeAction::class => autowire(Stats\RecentPodcastEpisodeAction::class),
    Stats\RecentSongAction::class => autowire(Stats\RecentSongAction::class),
    Stats\RecentVideoAction::class => autowire(Stats\RecentVideoAction::class),
    Stats\ShareAction::class => autowire(Stats\ShareAction::class),
    Stats\UploadAction::class => autowire(Stats\UploadAction::class),
    Stats\GraphAction::class => autowire(Stats\GraphAction::class),
    Stats\ShowAction::class => autowire(Stats\ShowAction::class),
    Logout\LogoutAction::class => autowire(Logout\LogoutAction::class),
    Rss\ShowAction::class => autowire(Rss\ShowAction::class),
    Shout\AddShoutAction::class => autowire(Shout\AddShoutAction::class),
    Shout\ShowAddShoutAction::class => autowire(Shout\ShowAddShoutAction::class),
    Shout\ShowAction::class => autowire(Shout\ShowAction::class),
    Waveform\ShowAction::class => autowire(Waveform\ShowAction::class),
    Search\SearchAction::class => autowire(Search\SearchAction::class),
    Search\SaveAsSmartPlaylistAction::class => autowire(Search\SaveAsSmartPlaylistAction::class),
    Search\SaveAsPlaylistAction::class => autowire(Search\SaveAsPlaylistAction::class),
    Search\DescriptorAction::class => autowire(Search\DescriptorAction::class),
    Search\ShowAction::class => autowire(Search\ShowAction::class),
    CookieDisclaimer\ShowAction::class => autowire(CookieDisclaimer\ShowAction::class),
    DemocraticPlayback\ManageAction::class => autowire(DemocraticPlayback\ManageAction::class),
    DemocraticPlayback\ShowCreateAction::class => autowire(DemocraticPlayback\ShowCreateAction::class),
    DemocraticPlayback\DeleteAction::class => autowire(DemocraticPlayback\DeleteAction::class),
    DemocraticPlayback\CreateAction::class => autowire(DemocraticPlayback\CreateAction::class),
    DemocraticPlayback\ManagePlaylistsAction::class => autowire(DemocraticPlayback\ManagePlaylistsAction::class),
    DemocraticPlayback\ShowPlaylistAction::class => autowire(DemocraticPlayback\ShowPlaylistAction::class),
    WebPlayer\ShowAction::class => autowire(WebPlayer\ShowAction::class),
    WebPlayer\ShowEmbeddedAction::class => autowire(WebPlayer\ShowEmbeddedAction::class),
    Index\ShowAction::class => autowire(Index\ShowAction::class),
    Utility\ShowAction::class => autowire(Utility\ShowAction::class),
    Update\ClearAction::class => autowire(Update\ClearAction::class),
    Update\ShowAction::class => autowire(Update\ShowAction::class),
    Update\UpdateAction::class => autowire(Update\UpdateAction::class),
    Update\UpdatePluginsAction::class => autowire(Update\UpdatePluginsAction::class),
    Video\DeleteAction::class => autowire(Video\DeleteAction::class),
    Video\ConfirmDeleteAction::class => autowire(Video\ConfirmDeleteAction::class),
    Video\ShowVideoAction::class => autowire(Video\ShowVideoAction::class),
    Label\DeleteAction::class => autowire(Label\DeleteAction::class),
    Label\ConfirmDeleteAction::class => autowire(Label\ConfirmDeleteAction::class),
    Label\AddLabelAction::class => autowire(Label\AddLabelAction::class),
    Label\ShowAddLabelAction::class => autowire(Label\ShowAddLabelAction::class),
    Label\ShowAction::class => autowire(Label\ShowAction::class),
    Share\ShowCreateAction::class => autowire(Share\ShowCreateAction::class),
    Share\CreateAction::class => autowire(Share\CreateAction::class),
    Share\ShowDeleteAction::class => autowire(Share\ShowDeleteAction::class),
    Share\DeleteAction::class => autowire(Share\DeleteAction::class),
    Share\CleanAction::class => autowire(Share\CleanAction::class),
    Share\ExternalShareAction::class => autowire(Share\ExternalShareAction::class),
    Share\ConsumeAction::class => autowire(Share\ConsumeAction::class),
    Broadcast\ShowDeleteAction::class => autowire(Broadcast\ShowDeleteAction::class),
    Broadcast\DeleteAction::class => autowire(Broadcast\DeleteAction::class),
    Radio\ShowCreateAction::class => autowire(Radio\ShowCreateAction::class),
    Radio\CreateAction::class => autowire(Radio\CreateAction::class),
    Radio\ShowAction::class => autowire(Radio\ShowAction::class),
    Image\ShowAction::class => autowire(Image\ShowAction::class),
    Image\ShowUserAvatarAction::class => autowire(),
    Mashup\ShowAction::class => autowire(Mashup\ShowAction::class),
    Mashup\WrappedAction::class => autowire(Mashup\WrappedAction::class),
    Podcast\ShowCreateAction::class => autowire(Podcast\ShowCreateAction::class),
    Podcast\CreateAction::class => autowire(Podcast\CreateAction::class),
    Podcast\DeleteAction::class => autowire(Podcast\DeleteAction::class),
    Podcast\ConfirmDeleteAction::class => autowire(Podcast\ConfirmDeleteAction::class),
    Podcast\ShowAction::class => autowire(Podcast\ShowAction::class),
    Podcast\ExportPodcastsAction::class => autowire(),
    PodcastEpisode\DeleteAction::class => autowire(PodcastEpisode\DeleteAction::class),
    PodcastEpisode\ConfirmDeleteAction::class => autowire(PodcastEpisode\ConfirmDeleteAction::class),
    PodcastEpisode\ShowAction::class => autowire(PodcastEpisode\ShowAction::class),
    Upload\DefaultAction::class => autowire(Upload\DefaultAction::class),
    NowPlaying\ShowAction::class => autowire(NowPlaying\ShowAction::class),
    LostPassword\ShowAction::class => autowire(LostPassword\ShowAction::class),
    LostPassword\SendAction::class => autowire(LostPassword\SendAction::class),
    PrivateMessage\ShowAction::class => autowire(PrivateMessage\ShowAction::class),
    PrivateMessage\ConfirmDeleteAction::class => autowire(PrivateMessage\ConfirmDeleteAction::class),
    PrivateMessage\DeleteAction::class => autowire(PrivateMessage\DeleteAction::class),
    PrivateMessage\SetIsReadAction::class => autowire(PrivateMessage\SetIsReadAction::class),
    PrivateMessage\AddMessageAction::class => autowire(PrivateMessage\AddMessageAction::class),
    PrivateMessage\ShowAddMessageAction::class => autowire(PrivateMessage\ShowAddMessageAction::class),
    Test\ShowAction::class => autowire(Test\ShowAction::class),
    Test\ConfigAction::class => autowire(Test\ConfigAction::class),
    Stream\DownloadAction::class => autowire(Stream\DownloadAction::class),
    Stream\DemocraticAction::class => autowire(Stream\DemocraticAction::class),
    Stream\PlaylistRandomAction::class => autowire(Stream\PlaylistRandomAction::class),
    Stream\PlayItemAction::class => autowire(Stream\PlayItemAction::class),
    Stream\StreamItemAction::class => autowire(Stream\StreamItemAction::class),
    Stream\RandomAction::class => autowire(Stream\RandomAction::class),
    Stream\TmpPlaylistAction::class => autowire(Stream\TmpPlaylistAction::class),
    Stream\BasketAction::class => autowire(Stream\BasketAction::class),
    PhpInfo\ShowAction::class => autowire(PhpInfo\ShowAction::class),
    ShowGet\ShowAction::class => autowire(ShowGet\ShowAction::class),
    SearchData\ShowAction::class => autowire(SearchData\ShowAction::class),
    Register\ValidateAction::class => autowire(Register\ValidateAction::class),
    Register\ShowAddUserAction::class => autowire(Register\ShowAddUserAction::class),
    Register\AddUserAction::class => autowire(Register\AddUserAction::class),
    StatisticGraph\ShowAction::class => autowire(StatisticGraph\ShowAction::class),
    Random\AdvancedAction::class => autowire(Random\AdvancedAction::class),
    Random\GetAdvancedAction::class => autowire(Random\GetAdvancedAction::class),
    Batch\DefaultAction::class => autowire(Batch\DefaultAction::class),
    SmartPlaylist\ShowAction::class => autowire(SmartPlaylist\ShowAction::class),
    SmartPlaylist\RefreshPlaylistAction::class => autowire(SmartPlaylist\RefreshPlaylistAction::class),
    SmartPlaylist\UpdatePlaylistAction::class => autowire(SmartPlaylist\UpdatePlaylistAction::class),
    SmartPlaylist\DeletePlaylistAction::class => autowire(SmartPlaylist\DeletePlaylistAction::class),
    SmartPlaylist\CreatePlaylistAction::class => autowire(SmartPlaylist\CreatePlaylistAction::class),
    Playlist\ShowAction::class => autowire(Playlist\ShowAction::class),
    Playlist\SortTrackAction::class => autowire(Playlist\SortTrackAction::class),
    Playlist\RemoveDuplicatesAction::class => autowire(Playlist\RemoveDuplicatesAction::class),
    Playlist\AddSongAction::class => autowire(Playlist\AddSongAction::class),
    Playlist\SetTrackNumbersAction::class => autowire(Playlist\SetTrackNumbersAction::class),
    Playlist\ImportPlaylistAction::class => autowire(Playlist\ImportPlaylistAction::class),
    Playlist\ShowImportPlaylistAction::class => autowire(Playlist\ShowImportPlaylistAction::class),
    Playlist\DeletePlaylistAction::class => autowire(Playlist\DeletePlaylistAction::class),
    Playlist\RefreshPlaylistAction::class => autowire(Playlist\RefreshPlaylistAction::class),
    Playlist\CreatePlaylistAction::class => autowire(Playlist\CreatePlaylistAction::class),
    Installation\DefaultAction::class => autowire(Installation\DefaultAction::class),
    Preferences\UpdateUserAction::class => autowire(Preferences\UpdateUserAction::class),
    Preferences\UserAction::class => autowire(Preferences\UserAction::class),
    Preferences\ShowAction::class => autowire(Preferences\ShowAction::class),
    Preferences\AdminAction::class => autowire(Preferences\AdminAction::class),
    Preferences\AdminUpdatePreferencesAction::class => autowire(Preferences\AdminUpdatePreferencesAction::class),
    Preferences\UpdatePreferencesAction::class => autowire(Preferences\UpdatePreferencesAction::class),
    Preferences\GrantAction::class => autowire(Preferences\GrantAction::class),
    Login\DefaultAction::class => autowire(Login\DefaultAction::class),
    LocalPlay\ShowAddInstanceAction::class => autowire(LocalPlay\ShowAddInstanceAction::class),
    LocalPlay\ShowPlaylistAction::class => autowire(LocalPlay\ShowPlaylistAction::class),
    LocalPlay\AddInstanceAction::class => autowire(LocalPlay\AddInstanceAction::class),
    LocalPlay\UpdateInstanceAction::class => autowire(LocalPlay\UpdateInstanceAction::class),
    LocalPlay\EditInstanceAction::class => autowire(LocalPlay\EditInstanceAction::class),
    LocalPlay\ShowInstancesAction::class => autowire(LocalPlay\ShowInstancesAction::class),
    Browse\TagAction::class => autowire(Browse\TagAction::class),
    Browse\FileAction::class => autowire(Browse\FileAction::class),
    Browse\AlbumAction::class => autowire(Browse\AlbumAction::class),
    Browse\AlbumArtistAction::class => autowire(Browse\AlbumArtistAction::class),
    Browse\ArtistAction::class => autowire(Browse\ArtistAction::class),
    Browse\SongAction::class => autowire(Browse\SongAction::class),
    Browse\PlaylistAction::class => autowire(Browse\PlaylistAction::class),
    Browse\SmartPlaylistAction::class => autowire(Browse\SmartPlaylistAction::class),
    Browse\PodcastEpisodeAction::class => autowire(Browse\PodcastEpisodeAction::class),
    Browse\CatalogAction::class => autowire(Browse\CatalogAction::class),
    Browse\PrivateMessageAction::class => autowire(Browse\PrivateMessageAction::class),
    Browse\LiveStreamAction::class => autowire(Browse\LiveStreamAction::class),
    Browse\LabelAction::class => autowire(Browse\LabelAction::class),
    Browse\BroadcastAction::class => autowire(Browse\BroadcastAction::class),
    Browse\VideoAction::class => autowire(Browse\VideoAction::class),
    Browse\PodcastAction::class => autowire(Browse\PodcastAction::class),
    Art\ClearArtAction::class => autowire(Art\ClearArtAction::class),
    Art\ShowArtDlgAction::class => autowire(Art\ShowArtDlgAction::class),
    Art\FindArtAction::class => autowire(Art\FindArtAction::class),
    Art\UploadArtAction::class => autowire(Art\UploadArtAction::class),
    Art\SelectArtAction::class => autowire(Art\SelectArtAction::class),
    Playback\PlayAction::class => autowire(Playback\PlayAction::class),
    Admin\Mail\ShowAction::class => autowire(Admin\Mail\ShowAction::class),
    Admin\Mail\SendMailAction::class => autowire(Admin\Mail\SendMailAction::class),
    Admin\Export\ShowAction::class => autowire(Admin\Export\ShowAction::class),
    Admin\Export\ExportAction::class => autowire(Admin\Export\ExportAction::class),
    Admin\Access\ShowAction::class => autowire(Admin\Access\ShowAction::class),
    Admin\Access\ShowAddAdvancedAction::class => autowire(Admin\Access\ShowAddAdvancedAction::class),
    Admin\Access\ShowDeleteRecordAction::class => autowire(Admin\Access\ShowDeleteRecordAction::class),
    Admin\Access\UpdateRecordAction::class => autowire(Admin\Access\UpdateRecordAction::class),
    Admin\Access\AddHostAction::class => autowire(Admin\Access\AddHostAction::class),
    Admin\Access\DeleteRecordAction::class => autowire(Admin\Access\DeleteRecordAction::class),
    Admin\Access\ShowEditRecordAction::class => autowire(Admin\Access\ShowEditRecordAction::class),
    Admin\Access\ShowAddAction::class => autowire(Admin\Access\ShowAddAction::class),
    Admin\Catalog\ShowAddCatalogAction::class => autowire(Admin\Catalog\ShowAddCatalogAction::class),
    Admin\Catalog\ShowDisabledAction::class => autowire(Admin\Catalog\ShowDisabledAction::class),
    Admin\Catalog\ShowCustomizeCatalogAction::class => autowire(Admin\Catalog\ShowCustomizeCatalogAction::class),
    Admin\Catalog\ShowCatalogsAction::class => autowire(Admin\Catalog\ShowCatalogsAction::class),
    Admin\Catalog\ClearStatsAction::class => autowire(Admin\Catalog\ClearStatsAction::class),
    Admin\Catalog\ClearNowPlayingAction::class => autowire(Admin\Catalog\ClearNowPlayingAction::class),
    Admin\Catalog\DeleteCatalogAction::class => autowire(Admin\Catalog\DeleteCatalogAction::class),
    Admin\Catalog\ShowDeleteCatalogAction::class => autowire(Admin\Catalog\ShowDeleteCatalogAction::class),
    Admin\Catalog\AddToAllCatalogsAction::class => autowire(Admin\Catalog\AddToAllCatalogsAction::class),
    Admin\Catalog\UpdateCatalogAction::class => autowire(Admin\Catalog\UpdateCatalogAction::class),
    Admin\Catalog\FullServiceAction::class => autowire(Admin\Catalog\FullServiceAction::class),
    Admin\Catalog\AddToCatalogAction::class => autowire(Admin\Catalog\AddToCatalogAction::class),
    Admin\Catalog\CleanAllCatalogsAction::class => autowire(Admin\Catalog\CleanAllCatalogsAction::class),
    Admin\Catalog\CleanCatalogAction::class => autowire(Admin\Catalog\CleanCatalogAction::class),
    Admin\Catalog\GarbageCollectAction::class => autowire(Admin\Catalog\GarbageCollectAction::class),
    Admin\Catalog\UpdateFileTagsAction::class => autowire(Admin\Catalog\UpdateFileTagsAction::class),
    Admin\Catalog\UpdateAllFileTagsActions::class => autowire(Admin\Catalog\UpdateAllFileTagsActions::class),
    Admin\Catalog\GatherMediaArtAction::class => autowire(Admin\Catalog\GatherMediaArtAction::class),
    Admin\Catalog\ImportToCatalogAction::class => autowire(Admin\Catalog\ImportToCatalogAction::class),
    Admin\Catalog\AddCatalogAction::class => autowire(Admin\Catalog\AddCatalogAction::class),
    Admin\Catalog\UpdateFromAction::class => autowire(Admin\Catalog\UpdateFromAction::class),
    Admin\Catalog\UpdateAllCatalogsAction::class => autowire(Admin\Catalog\UpdateAllCatalogsAction::class),
    Admin\Catalog\EnableDisabledAction::class => autowire(Admin\Catalog\EnableDisabledAction::class),
    Admin\Catalog\UpdateCatalogSettingsAction::class => autowire(Admin\Catalog\UpdateCatalogSettingsAction::class),
    Admin\Filter\AbstractFilterAction::class => autowire(Admin\Filter\AbstractFilterAction::class),
    Admin\Filter\AddFilterAction::class => autowire(Admin\Filter\AddFilterAction::class),
    Admin\Filter\ConfirmDeleteAction::class => autowire(Admin\Filter\ConfirmDeleteAction::class),
    Admin\Filter\DeleteAction::class => autowire(Admin\Filter\DeleteAction::class),
    Admin\Filter\ShowAction::class => autowire(Admin\Filter\ShowAction::class),
    Admin\Filter\ShowAddFilterAction::class => autowire(Admin\Filter\ShowAddFilterAction::class),
    Admin\Filter\ShowEditAction::class => autowire(Admin\Filter\ShowEditAction::class),
    Admin\Filter\UpdateFilterAction::class => autowire(Admin\Filter\UpdateFilterAction::class),
    Admin\Index\ShowAction::class => autowire(Admin\Index\ShowAction::class),
    Admin\License\ShowAction::class => autowire(Admin\License\ShowAction::class),
    Admin\License\DeleteAction::class => autowire(Admin\License\DeleteAction::class),
    Admin\License\ShowCreateAction::class => autowire(Admin\License\ShowCreateAction::class),
    Admin\License\ShowEditAction::class => autowire(Admin\License\ShowEditAction::class),
    Admin\License\EditAction::class => autowire(Admin\License\EditAction::class),
    Admin\Shout\ShowAction::class => autowire(Admin\Shout\ShowAction::class),
    Admin\Shout\DeleteAction::class => autowire(Admin\Shout\DeleteAction::class),
    Admin\Shout\ShowEditAction::class => autowire(Admin\Shout\ShowEditAction::class),
    Admin\Shout\EditShoutAction::class => autowire(Admin\Shout\EditShoutAction::class),
    Admin\Modules\InstallLocalplayAction::class => autowire(Admin\Modules\InstallLocalplayAction::class),
    Admin\Modules\ShowAction::class => autowire(Admin\Modules\ShowAction::class),
    Admin\Modules\InstallCatalogTypeAction::class => autowire(Admin\Modules\InstallCatalogTypeAction::class),
    Admin\Modules\ConfirmUninstallCatalogType::class => autowire(Admin\Modules\ConfirmUninstallCatalogType::class),
    Admin\Modules\ConfirmUninstallLocalplayAction::class => autowire(Admin\Modules\ConfirmUninstallLocalplayAction::class),
    Admin\Modules\ConfirmUninstallPluginAction::class => autowire(Admin\Modules\ConfirmUninstallPluginAction::class),
    Admin\Modules\ConfirmInstallCatalogType::class => autowire(Admin\Modules\ConfirmInstallCatalogType::class),
    Admin\Modules\ConfirmInstallLocalplayAction::class => autowire(Admin\Modules\ConfirmInstallLocalplayAction::class),
    Admin\Modules\ConfirmInstallPluginAction::class => autowire(Admin\Modules\ConfirmInstallPluginAction::class),
    Admin\Modules\UninstallLocalplayAction::class => autowire(Admin\Modules\UninstallLocalplayAction::class),
    Admin\Modules\UninstallCatalogTypeAction::class => autowire(Admin\Modules\UninstallCatalogTypeAction::class),
    Admin\Modules\InstallPluginAction::class => autowire(Admin\Modules\InstallPluginAction::class),
    Admin\Modules\UninstallPluginAction::class => autowire(Admin\Modules\UninstallPluginAction::class),
    Admin\Modules\UpgradePluginAction::class => autowire(Admin\Modules\UpgradePluginAction::class),
    Admin\Modules\ShowPluginsAction::class => autowire(Admin\Modules\ShowPluginsAction::class),
    Admin\Modules\ShowLocalplayAction::class => autowire(Admin\Modules\ShowLocalplayAction::class),
    Admin\Modules\ShowCatalogTypesAction::class => autowire(Admin\Modules\ShowCatalogTypesAction::class),
    Admin\System\GenerateConfigAction::class => autowire(Admin\System\GenerateConfigAction::class),
    Admin\System\WriteConfigAction::class => autowire(Admin\System\WriteConfigAction::class),
    Admin\System\ResetDbCharsetAction::class => autowire(Admin\System\ResetDbCharsetAction::class),
    Admin\System\ShowDebugAction::class => autowire(Admin\System\ShowDebugAction::class),
    Admin\System\ClearCacheAction::class => autowire(Admin\System\ClearCacheAction::class),
    Admin\User\ShowAction::class => autowire(Admin\User\ShowAction::class),
    Admin\User\ShowPreferencesAction::class => autowire(Admin\User\ShowPreferencesAction::class),
    Admin\User\ShowAddUserAction::class => autowire(Admin\User\ShowAddUserAction::class),
    Admin\User\ShowIpHistoryAction::class => autowire(Admin\User\ShowIpHistoryAction::class),
    Admin\User\GenerateRssTokenAction::class => autowire(Admin\User\GenerateRssTokenAction::class),
    Admin\User\ShowGenerateRssTokenAction::class => autowire(Admin\User\ShowGenerateRssTokenAction::class),
    Admin\User\GenerateStreamTokenAction::class => autowire(Admin\User\GenerateStreamTokenAction::class),
    Admin\User\ShowGenerateStreamTokenAction::class => autowire(Admin\User\ShowGenerateStreamTokenAction::class),
    Admin\User\DeleteStreamTokenAction::class => autowire(Admin\User\DeleteStreamTokenAction::class),
    Admin\User\DeleteRssTokenAction::class => autowire(Admin\User\DeleteRssTokenAction::class),
    Admin\User\ShowDeleteStreamTokenAction::class => autowire(Admin\User\ShowDeleteStreamTokenAction::class),
    Admin\User\ShowDeleteRssTokenAction::class => autowire(Admin\User\ShowDeleteRssTokenAction::class),
    Admin\User\GenerateApiKeyAction::class => autowire(Admin\User\GenerateApiKeyAction::class),
    Admin\User\ShowGenerateApiKeyAction::class => autowire(Admin\User\ShowGenerateApiKeyAction::class),
    Admin\User\DeleteApiKeyAction::class => autowire(Admin\User\DeleteApiKeyAction::class),
    Admin\User\ShowDeleteApiKeyAction::class => autowire(Admin\User\ShowDeleteApiKeyAction::class),
    Admin\User\DeleteAvatarAction::class => autowire(Admin\User\DeleteAvatarAction::class),
    Admin\User\ShowDeleteAvatarAction::class => autowire(Admin\User\ShowDeleteAvatarAction::class),
    Admin\User\ShowDeleteAction::class => autowire(Admin\User\ShowDeleteAction::class),
    Admin\User\ConfirmDeleteAction::class => autowire(Admin\User\ConfirmDeleteAction::class),
    Admin\User\ShowEditAction::class => autowire(Admin\User\ShowEditAction::class),
    Admin\User\DisableAction::class => autowire(Admin\User\DisableAction::class),
    Admin\User\EnableAction::class => autowire(Admin\User\EnableAction::class),
    Admin\User\AddUserAction::class => autowire(Admin\User\AddUserAction::class),
    Admin\User\UpdateUserAction::class => autowire(Admin\User\UpdateUserAction::class),
];
